function valida_campo(field, error_class, regex, error_regex_message, error_message) {
    var valore;
    var errore_descrizione = field.next(error_class);
    if (field.attr('type') !== 'file') {
        valore = field.val();
        if(valore == "" || valore.length == 0) {
            field.addClass("is-invalid");
            errore_descrizione.addClass("invalid-feedback");
            errore_descrizione.text(error_message);
            aggiungi_errore_tabella_investimenti();
        } else if (regex != null && !regex.test(valore)) {
            field.addClass("is-invalid");
            errore_descrizione.addClass("invalid-feedback");
            errore_descrizione.text(error_regex_message);
            aggiungi_errore_tabella_investimenti();
        } else {
            field.removeClass("is-invalid");
            errore_descrizione.removeClass("invalid-feedback");
            errore_descrizione.text("");
            togli_errore_tabella_investimenti();
        }
    } else {
        valore = field[0].files[0];
        var allowedExtensions = /(\.pdf)$/i;
        var maxSize = 5 * 1024 * 1024;
        if (!valore) {
            field.addClass("is-invalid");
            errore_descrizione.text(error_message);
            errore_descrizione.addClass("invalid-feedback");
        } 
        else if (!allowedExtensions.test(valore.name)) {
            field.addClass("is-invalid");
            errore_descrizione.addClass("invalid-feedback");
            errore_descrizione.text("Formato non valido. Caricare solo file .pdf.");
        } 
        else if (valore.size > maxSize) {
            field.addClass("is-invalid");
            errore_descrizione.text("Il file deve essere inferiore a 5MB.");
            errore_descrizione.addClass("invalid-feedback");
        } 
        else {
            field.removeClass("is-invalid");
            errore_descrizione.text("");
            errore_descrizione.removeClass("invalid-feedback");
        }
    }
}

function aggiungi_errore_tabella_investimenti(){
    var errori_prev = $("#count_errori_tabella_investimenti").val();
    var errori = errori_prev*1 + 1*1;
    $("#count_errori_tabella_investimenti").val(errori);
}

function togli_errore_tabella_investimenti(){
    var errori_prev = $("#count_errori_tabella_investimenti").val();
    var errori = errori_prev*1 - 1*1;
    $("#count_errori_tabella_investimenti").val(errori);
}

function crea_riga_motivazione(id_per_motivazione, dati) {
    const $esistente = $("#tabella_sal_saldo tbody tr#" + id_per_motivazione);

    let categoria_motivazione = dati.categoria_motivazione;
    let tipologia = dati.tipologia;

    if ($esistente.length > 0) {
        if (!('categoria_motivazione' in dati)) {
            const testo_categoria = $esistente.find(`#categoria_motivazione_${id_per_motivazione}`).text().trim();
            if (testo_categoria) categoria_motivazione = testo_categoria;
        }
        if (!('tipologia' in dati)) {
            const testo_tipologia = $esistente.find(`#tipologia_avanzamento_${id_per_motivazione}`).text().trim();
            if (testo_tipologia) tipologia = testo_tipologia;
        }
    }

    let riga = `<tr id="${id_per_motivazione}">`;

    const categoria = resolve_categoria(categoria_motivazione);
    riga += `<td>${categoria ? `<p id="categoria_motivazione_${id_per_motivazione}">${categoria}</p>` : ''}</td>`;

    const tipo = resolve_tipologia(tipologia);
    riga += `<td>${tipo ? `<p id="tipologia_avanzamento_${id_per_motivazione}">${tipo}</p>` : ''}</td>`;

    if (tipo === "SALDO") {
        riga += `
            <td>
                <input type="file" class="form-control" name="saldo_relazione">
                <div class="error_saldo_relazione"></div>
            </td>
            <td><p>NON RICHIESTO</p></td>
            <td><p>NON RICHIESTO</p></td>`;
    } else if (tipo === "SAL") {
        riga += `
            <td><p>NON RICHIESTA</p></td>
            <td>
                <input type="file" class="form-control" name="sal">
                <div class="error_sal"></div>
            </td>
            <td>
                <input type="file" class="form-control" name="sal_certificato">
                <div class="error_sal_certificato"></div>
            </td>`;
    } else {
        riga += `<td></td><td></td><td></td>`;
    }

    riga += `</tr>`;

    $esistente.length > 0
        ? $esistente.replaceWith(riga)
        : $("#tabella_sal_saldo tbody").append(riga);
}

function resolve_categoria(categoria) {
    return isNaN(categoria) ? categoria : ottieni_categoria(String(categoria));
}

function resolve_tipologia(tipologia) {
    return isNaN(tipologia) ? tipologia : ottieni_tipologia(String(tipologia));
}

function ottieni_categoria(id) {
    const mappa = {
        '1': "Captazione, nuova realizzazione, manutenzione e miglioramento di sistemi di raccolta e stoccaggio (vasche, serbatoi, laghetti, etc) delle acque da destinare ad uso agricolo e zootecnico",
        '2': "Nuovi pozzi e/o miglioramento di pozzi esistenti.",
        '3': "Recupero e trattamento delle acque reflue.",
        '4': "Impianti di mini-desalinizzazione.",
        '5': "Motopompe, elettropompe e altre attrezzature necessarie.",
        '6': "Interventi connessi ai precedenti interventi con l’obiettivo di assicurarne la piena funzionalità."
    };
    return mappa[id] || '';
}

function ottieni_tipologia(id) {
    const mappa = {
        '1': "SAL",
        '2': "SALDO"
    };
    return mappa[id] || '';
}

$(document).on("change", "input[type=file]", function() {
    const MAX_BYTES = 5 * 1024 * 1024; // 5 MB
    const $input = $(this);
    const files = this.files;
    if (!files || files.length === 0) {
      return; // nessun file selezionato, ok
    }
    const f = files[0];
    if (f.size > MAX_BYTES) {
      // File troppo grande
      $input.addClass("is-invalid");
      // Mostra messaggio d’errore vicino all’input
      const $err = $input.next(".invalid-feedback");
      if ($err.length === 0) {
        // se non esiste, crealo
        $input.after(`<div class="invalid-feedback d-block">Il file "${f.name}" supera 5 MB: riduci la dimensione.</div>`);
      } else {
        $err.addClass("d-block").text(`Il file "${f.name}" supera 5 MB: riduci la dimensione.`);
      }
    } else {
      // File ok
      $input.removeClass("is-invalid");
      $input.next(".invalid-feedback").removeClass("d-block").text("");
    }
  });
